package game;

import java.io.BufferedReader;
import java.io.IOException;


public class BossSpawnPoint {
	
	private int xPos = Integer.MIN_VALUE;
	private int yPos = Integer.MIN_VALUE; 
	private int xFlagSpawn = Integer.MIN_VALUE; 
	private int yFlagSpawn = Integer.MIN_VALUE; 
	private int kind = RainbowElementalSprite.NO_SPAWNING;
	
	private BossSpawnPoint() {}
	
	public static BossSpawnPoint readFromFile(BufferedReader in) throws IOException {
		
		BossSpawnPoint returnValue = new BossSpawnPoint();
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("x:")) {
				returnValue.xPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("y:")) {
				returnValue.yPos = Integer.parseInt(inputter.substring(2).trim());
			} else if(inputter.contains("safeX:")) {
				returnValue.xFlagSpawn = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("safeY:")) {
				returnValue.yFlagSpawn = Integer.parseInt(inputter.substring(6).trim());
			} else if(inputter.contains("spawnEnemies")) {
				returnValue.kind = RainbowElementalSprite.SPAWN_TWO;
			} else if(inputter.contains("spawnSixEnemies")) {
				returnValue.kind = RainbowElementalSprite.SPAWN_SIX;
			} else if(inputter.contains("/boss")) {
				break;
			}
			
		}
		
		
		if(returnValue.xFlagSpawn == Integer.MIN_VALUE
				|| returnValue.xPos == Integer.MIN_VALUE
				|| returnValue.yFlagSpawn == Integer.MIN_VALUE 
				|| returnValue.yPos == Integer.MIN_VALUE) {
			return null;
		}
		
		
		return returnValue;
	}

	public int getxPos() {
		return xPos;
	}

	public int getyPos() {
		return yPos;
	}

	public int getxFlagSpawn() {
		return xFlagSpawn;
	}

	public int getyFlagSpawn() {
		return yFlagSpawn;
	}
	
	public int getKind() {
		return kind;
	}
	
}
